package ch.frankel.blog.lombok.handler;

import lombok.javac.JavacNode;

import com.sun.tools.javac.code.Type;

/**
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class ParamTypeMapper implements Mapper<Class<?>, Type> {

    /** Class mapper. */
    private final ClassTypeParamMapper ctpm;

    /** Primitive type mapper. */
    private final PrimitiveTypeParamMapper ptpm;

    /**
     * Constructor.
     * 
     * @param node
     *            AST node
     */
    public ParamTypeMapper(JavacNode node) {

        ptpm = new PrimitiveTypeParamMapper(node.getSymbolTable());

        ctpm = new ClassTypeParamMapper(node);
    }

    /**
     * @see Mapper#get(Object)
     */
    public Type get(Class<?> clazz) {

        Type type = ptpm.get(clazz);

        if (type == null) {

            type = ctpm.get(clazz).asType();
        }

        return type;
    }
}
